// heapSort.java
// demonstracja sortowania stertowego
// aby uruchomi program: C>java HeapSortApp (wersja angielska)
// aby skompilowa wersj polsk: C>javac heapSort.java
// po kompilacji:         C>java HeapSortApp
import java.io.*;
////////////////////////////////////////////////////////////////
class Node
   {
   private int iData;             // element danych (klucz)
// -------------------------------------------------------------
   public Node(int key)           // konstruktor
      { iData = key; }
// -------------------------------------------------------------
   public int getKey()
      { return iData; }
// -------------------------------------------------------------
   }  // end class Node
////////////////////////////////////////////////////////////////
class Heap
   {
   private Node[] heapArray;
   private int maxSize;           // rozmiar tablicy
   private int currentSize;       // liczba elementw w tablicy
// -------------------------------------------------------------
   public Heap(int mx)            // konstruktor
      {
      maxSize = mx;
      currentSize = 0;
      heapArray = new Node[maxSize];
      }
// -------------------------------------------------------------
   public Node remove()           // usu element o najwyszej wartoci klucza
      {                           // (zakadamy, e lista nie jest pusta)
      Node root = heapArray[0];
      heapArray[0] = heapArray[--currentSize];
      trickleDown(0);
      return root;
      }  // end remove()
// -------------------------------------------------------------
   public void trickleDown(int index)
      {
      int largerChild;
      Node top = heapArray[index];        // zapisz korze
      while(index < currentSize/2)        // pomijamy ostatni wiersz
         {
         int leftChild = 2*index+1;
         int rightChild = leftChild+1;
                                          // znajd wikszego potomka
         if(rightChild < currentSize &&   // czy prawy potomek istnieje?
                             heapArray[leftChild].getKey() <
                             heapArray[rightChild].getKey())
            largerChild = rightChild;
         else
            largerChild = leftChild;
                                          // top >= largerChild?
         if(top.getKey() >= heapArray[largerChild].getKey())
            break;
                                          // przenosimy potomka do gry
         heapArray[index] = heapArray[largerChild];
         index = largerChild;             // przechodzimy w d
         }  // end while
      heapArray[index] = top;             // korze na pozycj 'index'
      }  // end trickleDown()
// -------------------------------------------------------------
   public void displayHeap()
      {
      int nBlanks = 32;
      int itemsPerRow = 1;
      int column = 0;
      int j = 0;                          // biecy element
      String dots = "...............................";
      System.out.println(dots+dots);      // grna linia kropkowana

      while(currentSize > 0)              // dla kadego elementu sterty
         {
         if(column == 0)                  // pierwszy element w wierszu?
            for(int k=0; k<nBlanks; k++)  // poprzedzajce znaki odstpu
               System.out.print(' ');
                                          // wywietl element
         System.out.print(heapArray[j].getKey());

         if(++j == currentSize)           // zakoczone?
            break;

         if(++column==itemsPerRow)        // koniec wiersza?
            {
            nBlanks /= 2;                 // poowa znakw odstpu
            itemsPerRow *= 2;             // dwa razy wiksza liczba elementw
            column = 0;                   // rozpoczynamy od nowa
            System.out.println();         //    w nastpnym wierszu
            }
         else                             // nastpny element w wierszu
            for(int k=0; k<nBlanks*2-2; k++)
               System.out.print(' ');     // znaki odstpu midzy elementami
         }  // end for
      System.out.println("\n"+dots+dots); // dolna linia kropkowana
      }  // end displayHeap()
// -------------------------------------------------------------
   public void displayArray()
      {
      for(int j=0; j<maxSize; j++)
         System.out.print(heapArray[j].getKey() + " ");
      System.out.println("");
      }
// -------------------------------------------------------------
   public void insertAt(int index, Node newNode)
      { heapArray[index] = newNode; }
// -------------------------------------------------------------
   public void incrementSize()
      { currentSize++; }
// -------------------------------------------------------------
   }  // end class Heap
////////////////////////////////////////////////////////////////
class HeapSortApp
   {
   public static void main(String[] args) throws IOException
      {
      int size, j;

      System.out.print("Wprowad liczb elementw: ");
      size = getInt();
      Heap theHeap = new Heap(size);

      for(j=0; j<size; j++)       // wypenij tablic
         {                        //    losowo
         int random = (int)(java.lang.Math.random()*100);
         Node newNode = new Node(random);
         theHeap.insertAt(j, newNode);
         theHeap.incrementSize();
         }

      System.out.print("Dane losowe: ");
         theHeap.displayArray();  // wywietl tablic danych losowych

      for(j=size/2-1; j>=0; j--)  // przekszta tablic w stert
         theHeap.trickleDown(j);

      System.out.print("Sterta:   ");
      theHeap.displayArray();     // wywietl tablic sterty
      theHeap.displayHeap();      // wywietl stert

      for(j=size-1; j>=0; j--)    // usu ze sterty i
         {                        //    zapisz na kocu tablicy
         Node biggestNode = theHeap.remove();
         theHeap.insertAt(j, biggestNode);
         }
      System.out.print("Dane posortowane: ");
      theHeap.displayArray();     // wywietl posortowan tablic
      }  // end main()
// -------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
// -------------------------------------------------------------
  }  // end class HeapSortApp
////////////////////////////////////////////////////////////////
